﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager;

public partial class Default2 : System.Web.UI.Page
{
    private UserAccountManager _currentUser;
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }

        string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
        UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;

        ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser1.FullName);

        //ReportViewer1.ServerReport.DisplayName = "What";
        
        ReportViewer1.Reset();

        _reportParameters.Clear();
        _reportParameters.Add(reportParamUsername);

        ReportViewer1.ServerReport.ReportPath = "ReportVISNCompare";

        //var config = RegistriesConfigurations.GetConfig();

        ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
        //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
        if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
        {
            ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
            //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
        }
        ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());

        ReportViewer1.ProcessingMode = ProcessingMode.Remote;

        ReportViewer1.Visible = true;
        ReportViewer1.ServerReport.Refresh();
    }
    public bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return _currentUser.IsInRole(16);
    }
}
